/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.eventlog;

import filenet.pa.sql.PAPEPartition;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.pa.eventlog.EventLogBaseNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogConfigPanel;
import filenet.vw.apps.taskman.pa.eventlog.EventLogRegionNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogRootNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class EventLogNode
extends EventLogBaseNode {
    private boolean m_bAllEventLog = false;
    private PAPEPartition m_partition = null;
    private static final ImageIcon ICON = VWImageLoader.createImageIcon("dataset_16.gif");

    public EventLogNode(PAPEPartition partition) {
        this(partition, false);
    }

    public EventLogNode(PAPEPartition partition, boolean allLogs) {
        super(EventLogNode.buildNodeName(partition, allLogs), ICON);
        this.m_partition = partition;
        this.m_bAllEventLog = allLogs;
    }

    private static String buildNodeName(PAPEPartition p, boolean allLogs) {
        String name = null;
        if (allLogs) {
            name = VWResource.AllEventLogs;
        } else {
            int index;
            name = p.getEventLog();
            if (name.startsWith("VWVL") && (index = name.indexOf("_")) != -1 && name.length() > index + 1) {
                name = name.substring(index + 1, name.length());
            }
        }
        return name;
    }

    public EventLogRegionNode getRegionNode() {
        return (EventLogRegionNode)this.getParent();
    }

    public String getLogName() {
        return this.getPartition().getEventLog();
    }

    public PAPEPartition getPartition() {
        return this.m_partition;
    }

    public boolean isAllEventLog() {
        return this.m_bAllEventLog;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.isAllEventLog()) {
            Enumeration<? extends TreeNode> j = this.getParent().children();
            while (j.hasMoreElements()) {
                EventLogNode eNode = (EventLogNode)j.nextElement();
                if (eNode.isAllEventLog()) continue;
                eNode.setSelected(true);
            }
        }
    }

    public boolean isEnabled() {
        EventLogRegionNode regionNode = (EventLogRegionNode)this.getParent();
        if (regionNode == null) {
            return false;
        }
        boolean enabled = true;
        if (regionNode.isSelected()) {
            if (this.isAllEventLog()) {
                EventLogConfigPanel panel = ((EventLogRootNode)this.getRoot()).getPanel();
                HashMap partitionMap = panel.getCommittedPartitionMap(this.getPartition().getRegionId());
                boolean regionCommitted = partitionMap != null;
                boolean allLogCommitted = regionCommitted && partitionMap.containsKey(this.getPartition().getEventLog());
                enabled = !regionCommitted || allLogCommitted;
            } else if (regionNode.getAllEventLogNode().isSelected()) {
                enabled = false;
            }
        } else {
            enabled = false;
        }
        return enabled;
    }
}

